<?php

declare(strict_types=1);

namespace Drupal\Tests\operation\Unit;

use Drupal\operation\Data\JobId;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * {@selfdoc}
 */
#[CoversClass(JobId::class)]
final class JobIdTest extends UnitTestCase {

  /**
   * {@selfdoc}
   */
  public function test(): void {
    self::assertSame('11d547a0-8448-4081-a665-c3d3f89dbadb', new JobId('11d547a0-8448-4081-a665-c3d3f89dbadb')->value);
    self::assertSame('281192e5-4802-4e7b-b510-b99175a489bf', (string) new JobId('281192e5-4802-4e7b-b510-b99175a489bf'));
    self::expectExceptionObject(new \InvalidArgumentException('Job ID must be exactly 36 characters long.'));
    new JobId('123');
  }

}
