<?php

declare(strict_types=1);

namespace Drupal\Tests\operation\Unit;

use Drupal\operation\Data\JobId;
use Drupal\operation\Data\JobInput;
use Drupal\operation\Data\OperationId;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * {@selfdoc}
 */
#[CoversClass(JobInput::class)]
final class JobInputTest extends UnitTestCase {

  /**
   * {@selfdoc}
   */
  public function test(): void {
    $input = new JobInput(
      jobId: new JobId('d0c9a560-b126-4009-ba26-0b890bb0c962'),
      operationId: new OperationId('8b487ae5-43fa-4df8-ba59-de2bc791cd1a'),
      payload: [123, 'abc', TRUE],
    );
    self::assertEquals(new JobId('d0c9a560-b126-4009-ba26-0b890bb0c962'), $input->jobId);
    self::assertEquals(new OperationId('8b487ae5-43fa-4df8-ba59-de2bc791cd1a'), $input->operationId);
    self::assertSame([123, 'abc', TRUE], $input->payload);
  }

}
