<?php

declare(strict_types=1);

namespace Drupal\Tests\operation\Unit;

use Drupal\operation\Data\JobId;
use Drupal\operation\Data\JobInput;
use Drupal\operation\Data\JobOutput;
use Drupal\operation\Data\OperationId;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * {@selfdoc}
 */
#[CoversClass(JobOutput::class)]
final class JobOutputTest extends UnitTestCase {

  /**
   * {@selfdoc}
   */
  public function test(): void {
    $input = new JobOutput(
      jobId: new JobId('ff03b18a-ba73-4612-924a-05177b6cfca2'),
      operationId: new OperationId('5a0ca939-2675-4c1a-86c0-9295d5e7a3dd'),
      output: 'success',
    );
    self::assertEquals(new JobId('ff03b18a-ba73-4612-924a-05177b6cfca2'), $input->jobId);
    self::assertEquals(new OperationId('5a0ca939-2675-4c1a-86c0-9295d5e7a3dd'), $input->operationId);
    self::assertSame('success', $input->output);
  }

  /**
   * {@selfdoc}
   */
  public function testFromJobInput(): void {
    $input = new JobInput(
      jobId: new JobId('70c6e1dc-7361-4005-933d-e5253744f86b'),
      operationId: new OperationId('be1eca45-0fa5-4957-af04-7eacf134b57b'),
      payload: [123, 'abc', TRUE],
    );
    $expected_output = new JobOutput(
      jobId: new JobId('70c6e1dc-7361-4005-933d-e5253744f86b'),
      operationId: new OperationId('be1eca45-0fa5-4957-af04-7eacf134b57b'),
      output: '123',
    );
    $actual_output = JobOutput::fromJobInput($input, '123');
    self::assertEquals($expected_output, $actual_output);
  }

}
