<?php

declare(strict_types=1);

namespace Drupal\Tests\operation\Unit;

use Drupal\operation\Data\OperationId;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * {@selfdoc}
 */
#[CoversClass(OperationId::class)]
final class OperationIdTest extends UnitTestCase {

  /**
   * {@selfdoc}
   */
  public function test(): void {
    self::assertSame('68e9e1f7-c875-419f-a61d-42431d49f223', new OperationId('68e9e1f7-c875-419f-a61d-42431d49f223')->value);
    self::assertSame('5bdca701-83f6-4aca-82ce-da16e11ddb7c', (string) new OperationId('5bdca701-83f6-4aca-82ce-da16e11ddb7c'));
    self::expectExceptionObject(new \InvalidArgumentException('Job ID must be exactly 36 characters long.'));
    new OperationId('123');
  }

}
