<?php

declare(strict_types=1);

namespace Drupal\Tests\operation\Unit;

use Drupal\operation\Data\OperationStatus;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * {@selfdoc}
 */
#[CoversClass(OperationStatus::class)]
final class OperationStatusTest extends UnitTestCase {

  /**
   * {@selfdoc}
   */
  public function test(): void {
    $expected_names = [
      'Pending',
      'InProgress',
      'Completed',
      'Failed',
      'Cancelled',
    ];
    self::assertSame($expected_names, \array_column(OperationStatus::cases(), 'name'));

    $expected_values = [
      'pending',
      'in_progress',
      'completed',
      'failed',
      'cancelled',
    ];
    self::assertSame($expected_values, \array_column(OperationStatus::cases(), 'value'));
  }

}
