# Optimize Database Tables (Drupal module)

Optimize Database Tables is a lightweight Drupal module that helps you reclaim storage and improve performance by running SQL OPTIMIZE on your site's database tables. It supports optimizing all tables or a curated subset, with both UI and Drush-based workflows. The module also reports size before/after and estimated space saved.

## Features

- Optimize all database tables or only selected tables.
- Batch UI for safe, interruptible operations in the admin interface.
- Drush command with progress bar and optional per‑table details.
- Summary of total size before/after and space saved (bytes and percentage).
- Minimal permissions surface: a single administrative permission.

## Requirements

- Drupal core: 10 or 11.
- Database: MySQL/MariaDB (uses OPTIMIZE TABLE). Other drivers are not supported. PostgreSQL support is planned and coming soon.
- Drush (optional) for command-line optimization.

## Compatibility

- Drupal 10.x and 11.x.
- Standard MySQL/MariaDB setups; ensure your DB user has privileges to run OPTIMIZE TABLE.

## Installation

1. Place the module in: web/modules/custom/optimize_database_tables
2. Clear caches if needed: `drush cr`
3. Enable the module:

- UI: Extend → “Optimize Database Tables”
- Drush: `drush en optimize_database_tables -y`

## Configuration

Admin UI path:

- /admin/config/system/database_optimize_tables

Settings stored in config: `optimize_database_tables.settings`

- `all_tables` (boolean): if TRUE, optimize all base tables.
- `table_list` (string[]): list of table names to optimize when `all_tables` is FALSE.

Configuration form tabs/links:

- Main settings: Optimize which tables to include.
- Run operation: button to start the batch from the UI.

Permission required: `administer_optimize_database`

- Grant this to trusted administrators only.

## Usage

### From the Admin UI

1. Go to Configuration → System → Optimize Database Tables

- Direct path: `/admin/config/system/database_optimize_tables`

2. Choose either “All tables” or select specific tables.
3. Start the optimization batch and wait for completion.
4. Review the summary messages (before/after/saved).

### From Drush

Command:

- `drush optimize_database_tables:run`
  Alias:
- `drush optimize-dbt:run`
  Options:
- `--details` Show per-table size before/after and % saved.

Examples:

- Optimize with a progress bar: `drush optimize-dbt:run`
- Optimize and show per-table details: `drush optimize-dbt:run --details`

Behavior when no tables are configured:

- The command prints a translatable warning with a dynamic link to the settings page.

## Safety and Limitations

- OPTIMIZE TABLE may lock tables briefly; run during low-traffic windows.
- Always ensure you have recent backups before performing maintenance operations.
- On very large tables, optimization can take a long time and use additional disk space.
- This module targets MySQL/MariaDB only. If you use another database driver, do not enable it.

## Troubleshooting

- “No tables to optimize” message:
  - Ensure configuration is set (either All tables, or a non-empty table list).
  - Verify your database user has privileges to list and optimize tables.
- Batch seems stuck or slow:
  - Check web server/PHP max execution time and increase if needed.
  - Prefer Drush CLI for large datasets.
- Errors in logs:
  - Check Recent log messages and the `optimize_database_tables` channel for details.

## Contributing

Issues and contributions are welcome. Follow Drupal coding standards

## License

This project is licensed under the same terms as Drupal (GPL-2.0-or-later), unless otherwise stated in your distribution.
