<?php

namespace Drupal\optimizely\Controller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of Optimizely.
 */
class OptimizelyListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Project name');
    $header['code'] = $this->t('Project code');
    $header['state'] = $this->t('Project state');
    $header['path'] = $this->t('Project path(s)');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['code'] = $entity->id() === 'default' ? \Drupal::configFactory()->getEditable('optimizely.settings')->get('optimizely_id') : $entity->getCode();
    $row['state'] = $entity->getState() ? 'Enabled' : 'Disabled';
    $row['paths'] = str_replace("\r\n", ', ', $entity->getPaths());

    return $row + parent::buildRow($entity);
  }

}
