<?php

namespace Drupal\optimizely\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the Optimizely entity.
 *
 * @ConfigEntityType(
 *   id = "optimizely",
 *   label = @Translation("Optimizely"),
 *   handlers = {
 *     "list_builder" = "Drupal\optimizely\Controller\OptimizelyListBuilder",
 *     "form" = {
 *       "default" = "Drupal\optimizely\Form\OptimizelyForm",
 *       "add" = "Drupal\optimizely\Form\OptimizelyForm",
 *       "edit" = "Drupal\optimizely\Form\OptimizelyForm",
 *       "delete" = "Drupal\optimizely\Form\OptimizelyDeleteForm",
 *     }
 *   },
 *   config_prefix = "optimizely",
 *   admin_permission = "administer site configuration",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "code" = "code",
 *     "state" = "state",
 *     "paths" = "paths",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "code",
 *     "state",
 *     "paths",
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/system/optimizely/{optimizely}",
 *     "delete-form" = "/admin/config/system/optimizely/{optimizely}/delete",
 *   }
 * )
 */
class Optimizely extends ConfigEntityBase {

  /**
   * The project ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The project label.
   *
   * @var string
   */
  protected $label;

  /**
   * The project code.
   *
   * @var string
   */
  protected $code;

  /**
   * The project state.
   *
   * @var string
   */
  protected $state;

  /**
   * The paths the project is enabled for.
   *
   * @var string
   */
  protected $paths;

  /**
   * {@inheritdoc}
   */
  public function id() {
    return $this->id;
  }

  /**
   * {@inheritdoc}
   */
  public function label() {
    return $this->label;
  }

  /**
   * {@inheritdoc}
   */
  public function getCode() {
    if ($this->label() == 'Default') {
      return \Drupal::config('optimizely.settings')->get('optimizely_id');
    }
    else {
      return $this->code;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getState() {
    return $this->state;
  }

  /**
   * {@inheritdoc}
   */
  public function getPaths() {
    return $this->paths;
  }

}
