<?php

namespace Drupal\Tests\optimizely\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test the account Id and the Default project.
 *
 * @group Optimizely
 */
class OptimizelyDefaultSettingsTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * The path to the settings page.
   *
   * @var string
   */
  protected $settingsPage = 'admin/config/system/optimizely/settings';

  protected $updateDefaultProjPage = 'admin/config/system/optimizely/add_update/1';

  /**
   * The permission to configure Optimizely.
   *
   * @var string
   */
  protected $optimizelyPermission = 'administer optimizely';

  /**
   * A user who can administer Optimizely, view/edit content and add aliases.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $privilegedUser;

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['optimizely'];

  /**
   * {@inheritdoc}
   */
  public static function getInfo() {

    return [
      'name' => 'Optimizely Default Settings',
      'description' => 'Ensure that project settings work correctly',
      'group' => 'Optimizely',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {

    parent::setUp();

    $this->privilegedUser = $this->drupalCreateUser([$this->optimizelyPermission]);
  }

  /**
   * Test setting the Optimizely account id.
   *
   * Test enabling & disabling the Default project.
   */
  public function testDefaultSettings() {

    $this->drupalLogin($this->privilegedUser);

    // --- Add the Optimizely account ID.
    $edit = [
      'optimizely_id' => rand(0, 10000),
    ];
    $this->drupalGet($this->settingsPage);
    $this->submitForm($edit, 'Submit');

    // The Default project has project id of 1.
    $optimizely_id =
      \Drupal::database()->query('SELECT project_code FROM {optimizely} WHERE oid = 1')
        ->fetchField();
    $this->assertEquals($optimizely_id, $edit['optimizely_id']);

    // --- Enable the default project.
    $edit = [
      'optimizely_enabled' => 1,
    ];
    $this->drupalGet($this->updateDefaultProjPage);
    $this->submitForm($edit, 'Update');

    $enabled = \Drupal::database()->query('SELECT enabled FROM {optimizely} WHERE oid = 1')->fetchField();
    $this->assertEquals($enabled, $edit['optimizely_enabled']);

    // --- Disable the default project.
    $edit = [
      'optimizely_enabled' => 0,
    ];
    $this->drupalGet($this->updateDefaultProjPage);
    $this->submitForm($edit, 'Update');

    $enabled = \Drupal::database()->query('SELECT enabled FROM {optimizely} WHERE oid = 1')->fetchField();
    $this->assertEquals($enabled, $edit['optimizely_enabled']);
  }

}
