<?php

namespace Drupal\orchestration\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Provides base class for poll events.
 *
 * @internal
 *   This class is not meant to be used as a public API. It is subject for name
 *   change or may be removed completely, also on minor version updates.
 *
 * @package Drupal\orchestration\Event
 */
abstract class PollEventBase extends Event {

  /**
   * The poll output.
   *
   * @var array
   */
  protected array $output = [];

  /**
   * Constructs a PollEvent.
   *
   * @param string $wildcard
   *   The wildcard of the event in the ECA model.
   */
  public function __construct(
    protected string $wildcard,
  ) {}

  /**
   * Gets the wildcard.
   *
   * @return string
   *   The wildcard.
   */
  public function getWildcard(): string {
    return $this->wildcard;
  }

  /**
   * Gets the poll output.
   *
   * @return array
   *   The poll output.
   */
  public function getOutput(): array {
    return $this->output;
  }

}
