<?php

namespace Drupal\orchestration\Event;

/**
 * Provides a poll event by timestamp.
 *
 * @internal
 *   This class is not meant to be used as a public API. It is subject for name
 *   change or may be removed completely, also on minor version updates.
 *
 * @package Drupal\orchestration\Event
 */
class PollEventTimestamp extends PollEventBase {

  /**
   * Constructs a PollEvent.
   *
   * @param string $wildcard
   *   The wildcard of the event in the ECA model.
   * @param int $timestamp
   *   The timestamp when the last poll was executed.
   */
  public function __construct(
    string $wildcard,
    protected int $timestamp,
  ) {
    parent::__construct($wildcard);
  }

  /**
   * Add an item to the poll result.
   *
   * @param int $timestamp
   *   The timestamp when the data was created.
   * @param mixed $data
   *   The data.
   */
  public function addItem(int $timestamp, mixed $data): void {
    $this->output[] = [
      'timestamp' => $timestamp,
      'data' => $data,
    ];
  }

  /**
   * Returns the timestamp when the last poll was executed.
   *
   * @return int
   *   The timestamp when the last poll was executed.
   */
  public function getTimestamp(): int {
    return $this->timestamp;
  }

}
