<?php

namespace Drupal\orchestration\Event;

/**
 * Provides a poll event by ID.
 *
 * @internal
 *   This class is not meant to be used as a public API. It is subject for name
 *   change or may be removed completely, also on minor version updates.
 *
 * @package Drupal\orchestration\Event
 */
class PollEventId extends PollEventBase {

  /**
   * Constructs a PollEvent.
   *
   * @param string $wildcard
   *   The wildcard of the event in the ECA model.
   * @param string $id
   *   The last id which was received by the last poll.
   */
  public function __construct(
    string $wildcard,
    protected string $id,
  ) {
    parent::__construct($wildcard);
  }

  /**
   * Add an item to the poll result.
   *
   * @param string $id
   *   The id of the item represented by data.
   * @param mixed $data
   *   The data.
   */
  public function addItem(string $id, mixed $data): void {
    $this->output[] = [
      'id' => $id,
      'data' => $data,
    ];
  }

  /**
   * Returns the last id which was received by the last poll.
   *
   * @return string
   *   The last id.
   */
  public function getId(): string {
    return $this->id;
  }

}
