<?php

namespace Drupal\orchestration;

/**
 * Defines an interface for orchestration services.
 */
interface ServicesProviderInterface {

  /**
   * Returns the unique ID of the services provider.
   *
   * @return string
   *   The unique ID of the services provider.
   */
  public function getId(): string;

  /**
   * Executes the service with given parameters.
   *
   * @return \Drupal\orchestration\Service[]
   *   The execution result.
   */
  public function getAll(): array;

  /**
   * Executes the service with given parameters.
   *
   * @param \Drupal\orchestration\Service $service
   *   The service.
   * @param array $config
   *   The service configuration.
   *
   * @return array|string
   *   The execution result.
   */
  public function execute(Service $service, array $config): array|string;

}
