The Orchestration module exposes Drupal's capabilities to external automation platforms like Activepieces. It lets external systems trigger Drupal workflows, call AI agents, and execute business logic through a unified API. 

By acting as a bridge between Drupal and automation tools, the module enables two-way interaction: external platforms can invoke Drupal functions (e.g. run workflows, execute AI agents) and also respond to Drupal events (such as content updates, user registrations, or form submissions).

This integration makes it possible to build end-to-end automated processes that span Drupal and external services like CRMs, email platforms, spreadsheets, and hundreds of other tools.

For example, when a visitor submits a contact form in Drupal, an automation platform could add them to a CRM, send a personalized email, open a support ticket, and update a spreadsheet, all without custom code. 

## Key Features

Expose Drupal capabilities as callable tools:
- [ECA](https://www.drupal.org/project/eca) workflows can be triggered from outside Drupal
- [Drupal AI agents](https://www.drupal.org/project/ai) become accessible to external platforms  
- [Tool](https://www.drupal.org/project/tool) plugins can be invoked remotely

### Current Limitations

Currently works with [Activepieces](https://www.activepieces.com). We'd like to add support for other automation platforms like [n8n](https://n8n.io), [Zapier](https://zapier.com), and others.
