(function ($, Drupal) {
  const appCallback = (consent, app) => {
    document.dispatchEvent(
      new CustomEvent('orejimeAppCallback', {
        detail: { consent, app: app.name },
      }),
    );
  };

  const OrejimeConfig = {
    init(context, settings) {
      const lang = settings.orejime.language;
      const config = {
        privacyPolicyUrl: settings.orejime.privacy_policy,
        purposes: [],
        forceModal: settings.orejime.must_consent,
        forceBanner: settings.orejime.must_notice,
        default: true,
        translations: {},
        logo: settings.orejime.logo,
        debug: settings.orejime.debug,
        cookie: {
          name: settings.orejime.cookie_name,
          duration: Number(settings.orejime.expires_after_days),
          domain: settings.orejime.cookie_domain,
        },
      };

      const purposes = {};
      $.each(settings.orejime.manage, function (index, value) {
        purposes[value.name] = {
          id: value.name,
          title: value.label,
          description: value.description,
          isMandatory: Number(value.required),
          cookies: value.cookies,
          default: Number(value.default),
          callback: appCallback,
        };
      });

      if (
        settings.orejime.categories !== null &&
        settings.orejime.categories.length !== 0
      ) {
        const cat = [];
        $.each(settings.orejime.categories, function (index, value) {
          const apps = [];
          $.each(value.apps, function (i, v) {
            if (v !== 0) {
              apps.push(purposes[v]);
              delete purposes[v];
            }
          });
          cat.push({
            id: value.name,
            title: value.title,
            description: value.description,
            purposes: apps,
          });
        });
        config.purposes = cat;
      }
      Object.values(purposes).forEach((val) => {
        config.purposes.push(val);
      });
      return config;
    },
  };

  Drupal.behaviors.orejime = {
    attach(context, settings) {
      if (settings.orejime) {
        window.orejimeConfig = OrejimeConfig.init(context, settings);
      }
      if (document.querySelector('.consent-modal-button')) {
        document.querySelector('.consent-modal-button').addEventListener(
          'click',
          function () {
            orejime.prompt();
          },
          false,
        );
      }
      if (document.querySelector('.reset-button')) {
        document.querySelector('.reset-button').addEventListener(
          'click',
          function () {
            orejime.manager.clearConsents();
          },
          false,
        );
      }
    },
  };
})(jQuery, Drupal);
