<?php

namespace Drupal\orejime\Services;

use Drupal\Core\Asset\JsCollectionRenderer;

/**
 * Renders JavaScript assets.
 */
class JsCollectionRendererOrejime extends JsCollectionRenderer {

  /**
   * {@inheritdoc}
   *
   * This class evaluates the aggregation enabled/disabled condition on a group
   * by group basis by testing whether an aggregate file has been made for the
   * group rather than by testing the site-wide aggregation setting. This allows
   * this class to work correctly even if modules have implemented custom
   * logic for grouping and aggregating files.
   */
  public function render(array $js_assets) {
    $elements = parent::render($js_assets);
    foreach ($elements as &$element) {
      if (isset($element['#attributes']['data-purpose'])) {
        $purpose = $element['#attributes']['data-purpose'];
        unset($element['#attributes']['data-purpose']);
        $script = $element;
        $element = [
          '#type' => 'html_tag',
          '#tag' => 'template',
          'child' => $script,
          '#attributes' => [
            'data-purpose' => $purpose,
          ],
        ];
      }
    }
    return $elements;
  }

}
