/**
 * @file
 * Script used to save cookies user choice to database.
 *
 * Uses Drupal.behaviors.
 *
 * @see https://www.drupal.org/docs/8/api/javascript-api/javascript-api-overview
 */

'use strict';

(function (Drupal) {

  Drupal.behaviors.orejimeRegister = {
    attach: function (context, settings) {

      once('orejimeRegister', 'html', context).forEach( function() {
        if (window.orejime !== undefined) {
          hookOrejime();
        } else {
          Object.defineProperty(window,'orejime',{
            get: function(){
              return this.orejime_register;
            },

            set: function(val){
              this.orejime_register = val;
              hookOrejime();
            },

          configurable: true,
        });
        }
      })
    },
  };

  function hookOrejime () {
    window.orejime.internals.manager.saveAndApplyConsents = function () {
      window.orejime.internals.manager.saveConsents();
      window.orejime.internals.manager.applyConsents();
      fetch( "/orejime_register", {
        'method': 'POST',
        'headers': {'Content-Type': 'application/json'},
        'body': JSON.stringify(window.orejime.internals.manager.consents)
      });
    }
  }
}(Drupal));
