<?php

namespace Drupal\organization_field\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'organization_field' field type.
 *
 * Provides a field type of the organization.
 *
 * @FieldType(
 *   id = "organization_field",
 *   module = "organization_field",
 *   label = @Translation("Organization field"),
 *   category = @Translation("General"),
 *   description = @Translation("Organization field type with permission-based access control."),
 *   default_widget = "organization_field_widget",
 *   default_formatter = "organization_field_default"
 * )
 */
class OrganizationFieldItem extends FieldItemBase {

  /**
   * Stores the values for the organization fields into the database.
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    $columns = [
      'organization_name' => [
        'type' => 'varchar',
        'length' => 255,
      ],
      'organization_url' => [
        'type' => 'varchar',
        'length' => 2048,
      ],
      'organization_ror_id_url' => [
        'type' => 'varchar',
        'length' => 255,
      ],
    ];
    $schema = [
      'columns' => $columns,
    ];

    return $schema;
  }

  /**
   * The method determines when the field is empty.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   */
  public function isEmpty() {
    $value = $this->get('organization_name')->getValue();

    return $value === NULL || $value === '';
  }

  /**
   * The method defines more details about properties of the organization field.
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties['organization_name'] = DataDefinition::create('string')
      ->setLabel(t('Organization name'));
    $properties['organization_url'] = DataDefinition::create('string')
      ->setLabel(t('Organization URL'));
    $properties['organization_ror_id_url'] = DataDefinition::create('string')
      ->setLabel(t('ROR id'));

    return $properties;
  }

}
