# Organization field module

### Background

[ROR (Research Organization Registry)](https://ror.org/) is a community-led registry of open, sustainable, usable, and unique identifiers for every research organization in the world.
ROR includes identifiers and metadata for more than 100,000 organizations. ROR identifiers are designed to link research organizations to research outputs in scholarly infrastructure. Search the ROR registry at https://ror.org/search.

### About
Organization field module provides fields that store information associated with an organization as found in the Research Organization Registry (ROR). When this information is not found in ROR it allows the user to enter it manually. It also includes a form field formatter with autocomplete capability and a display field formatter to show the organization.

### Key capabilities
- Provides a form field formatter with an ability to autocomplete organization name as the user enters the text. The module uses ROR API to fetch records.
- Provides a display and form field formatters to customize display of Organization field.

### Fields
- Organization name: Stores name of the organization
- Organization URL: Stores multiple urls for the organization. First url is the default.
- ROR ID URL: Stores the url found in ROR

### Uninstall validation
This is implemented using a drupal form where custom script is executed to delete the dependent fields from the system. Currently, "node" and "storage" types are handled for the deletion.
