<?php

namespace Drupal\organization_field\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * Plugin implementation of the 'Default' formatter.
 *
 * The default formatter configures simply the (name link or name),
 * and ROR ID url of the organization.
 *
 * @FieldFormatter(
 *   id = "organization_field_default",
 *   module = "organization_field",
 *   label = @Translation("Default"),
 *   field_types = {
 *     "organization_field"
 *   }
 * )
 */
class OrganizationFieldDefaultFormatter extends FormatterBase {

  /**
   * Set up values for elements to view in the theme template.
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $element = [];

    foreach ($items as $delta => $item) {
      $values = $item->getValue();
      $element[$delta] = [
        '#theme' => 'organization_field_default',
        '#attributes' => [
          'class' => [
            'organization_field',
          ],
        ],
      ];
      $element[$delta]['#organization_name'] = $values['organization_name'];

      if ($values['organization_url']) {
        $org_urls = explode(',', $values['organization_url']);
        $element[$delta]['#organization_url'] = $org_urls;
      }

      if ($values['organization_ror_id_url']) {
        $element[$delta]['#organization_ror_id_url'] = $values['organization_ror_id_url'];
      }
    }

    return $element;
  }

}
