<?php

namespace Drupal\organization_field\ProxyClass;

use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Extension\ModuleUninstallValidatorInterface;
use Drupal\Core\StringTranslation\TranslationInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Module uninstall validator proxy service class.
 *
 * Enables lazy loading for organization_field.uninstall_validator.
 */
class OrganizationFieldUninstallValidator implements ModuleUninstallValidatorInterface {
  use DependencySerializationTrait;

  /**
   * The proxy service ID.
   *
   * @var string
   */
  protected string $drupalProxyService;

  /**
   * The lazy loaded service instance.
   *
   * @var \Drupal\organization_field\OrganizationFieldUninstallValidator
   */
  protected $service;

  /**
   * The service container.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface
   */
  protected $container;

  /**
   * Constructs a ProxyClass Drupal proxy object.
   */
  public function __construct(ContainerInterface $container, $drupal_proxy_service) {
    $this->container = $container;
    $this->drupalProxyService = $drupal_proxy_service;
  }

  /**
   * Lazy loads the service from the container.
   */
  protected function lazyLoad() {
    if (!isset($this->service)) {
      $this->service = $this->container->get($this->drupalProxyService);
    }

    return $this->service;
  }

  /**
   * {@inheritdoc}
   */
  public function validate($module) {
    return $this->lazyLoad()->validate($module);
  }

  /**
   * {@inheritdoc}
   */
  public function setStringTranslation(TranslationInterface $translation) {
    return $this->lazyLoad()->setStringTranslation($translation);
  }

}
