<?php

namespace Drupal\orphans_media\Form;

use Drupal\Core\Form\ConfirmFormHelper;
use Drupal\Core\Form\FormStateInterface;

/**
 * Trait ConfirmFormTrait. Confirm form trait.
 *
 * @package Drupal\orphans_media\Form
 */
trait ConfirmFormTrait {

  /**
   * Build confirm form.
   *
   * @param array $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return array
   *   The form structure.
   */
  public function buildConfirmForm(array $form, FormStateInterface $form_state): array {
    $form['#theme'] = 'confirm_form';
    $form['#attributes']['class'][] = 'confirmation';
    $form['#title'] = $this->t('Delete these items ?');

    $storage = &$form_state->getStorage();

    $form['changelist'] = [
      '#theme' => 'item_list',
      '#tree' => TRUE,
      '#items' => [],
    ];

    foreach ($storage['references'] as $reference) {
      if (!empty($reference)) {
        $form['changelist']['#items'][] = $this->t('<strong>@media</strong>', ['@media' => $reference]);
      }
    }

    $form['actions'] = ['#type' => 'actions'];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->getConfirmText(),
      '#button_type' => 'primary',
      '#submit' => [
        [$this, 'submitConfirmForm'],
      ],
    ];
    $form['actions']['cancel'] = ConfirmFormHelper::buildCancelLink($this, $this->getRequest());

    return $form;
  }

  /**
   * Submit confirm form.
   *
   * @param array $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return void
   *   The form structure.
   */
  public function submitConfirmForm(array &$form, FormStateInterface $form_state): void {
    $storage = &$form_state->getStorage();
    $references = $storage['references'];
    $this->orphansMediaManager->deleteMediaBatch($references);
  }

}
