<?php

namespace Drupal\otp_login\Plugin\Block;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Provides a block with link for otp login.
 *
 * @Block(
 *   id = "otp_login_link",
 *   admin_label = @Translation("OTP login link"),
 * )
 */
class OtpLoginLink extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    global $base_url;
    return [
      '#markup' => '<a href=' . $base_url . '/otp/login>Login using OTP</a>',
    ];
  }

  /**
   * {@inheritdoc}
   */
  protected function blockAccess(AccountInterface $account) {
    $config = \Drupal::config('otp_login.settings');
    $otp_login_active = $config->get('activate');
    return AccessResult::allowedIf($account->isAnonymous() && $otp_login_active);
  }

}
