<?php

namespace Drupal\otp_login\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form builder for the otp_login basic settings form.
 */
class BasicSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'otp_login_basic_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['otp_login.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('otp_login.settings');

    $form['basic'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Basic settings'),
      '#collapsible' => FALSE,
    ];
    $form['basic']['activate'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Activate OTP Login'),
      '#default_value' => $config->get('activate'),
      '#description' => $this->t('Activate authentication via OTP Login.'),
    ];

    $form['purge_user'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Purge users who have been blocked / not logged-in for'),
      '#collapsible' => FALSE,
      '#collapsed' => FALSE,
    ];
    $form['purge_user']['user_blocked_value'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Days'),
      '#description' => $this->t('Enter value in days.'),
      '#default_value' => $config->get('user_blocked_value'),
    ];

    $form['purge_user']['enabled_blocked_users'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enabled'),
      '#default_value' => $config->get('enabled_blocked_users'),
    ];

    $form['otp_expire'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Enter time after which OTP should expire.'),
      '#collapsible' => FALSE,
      '#collapsed' => FALSE,
    ];
    $form['otp_expire']['otp_expire_value'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Minutes'),
      '#description' => $this->t('Enter value in minutes.'),
      '#default_value' => $config->get('otp_expire_value'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $config = $this->config('otp_login.settings');

    $config->set('activate', $form_state->getValue('activate'));
    $config->set('user_blocked_value', $form_state->getValue('user_blocked_value'));
    $config->set('enabled_blocked_users', $form_state->getValue('enabled_blocked_users'));
    $config->set('otp_expire_value', $form_state->getValue('otp_expire_value'));
    $config->save();
  }

}
