# OpenTelemetry SDK

Integrates the OpenTelemetry SDK.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/otsdk).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/otsdk).


## Requirements

This module requires the OpenTelemetry SDK library:

- [OpenTelemetry SDK](https://github.com/opentelemetry-php/sdk)


## Recommended libraries

One of the exporter libraries is required in order to ship instrumentation
results to an OpenTelemetry endpoint.

- [OpenTelemetry Registry](https://opentelemetry.io/ecosystem/registry/?language=php&component=exporter)


## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

Add one or more of the recommended libraries using `composer`.


## Configuration

1. Enable the module at Administration > Extend.
1. Supply OpenTelemetry SDK configuration via settings.php.

Example:

```
$settings['otsdk'] = [
  Variables::OTEL_PHP_AUTOLOAD_ENABLED => TRUE,
  Variables::OTEL_METRICS_EXPORTER => 'console',
  Variables::OTEL_TRACES_EXPORTER => 'console',
  Variables::OTEL_LOGS_EXPORTER => 'console',
];
```

See the OpenTelemetry docs for a full list of supported settings.

- [General SDK Configuration](https://opentelemetry.io/docs/languages/sdk-configuration/general/)
- [OTLP Exporter Configuration](https://opentelemetry.io/docs/languages/sdk-configuration/otlp-exporter/)
- [PHP SDK Configuration](https://opentelemetry.io/docs/languages/php/sdk/#configuration)


## Maintainers

- [znerol](https://www.drupal.org/u/znerol)
