<?php

declare(strict_types=1);

namespace Drupal\otsdk\Configuration\Resolver;

use Drupal\Core\Site\Settings;
use OpenTelemetry\SDK\Common\Configuration\Resolver\ResolverInterface;

/**
 * An OpenTelemetry SDK configuration resolver based on Drupal site settings.
 */
class SettingsResolver implements ResolverInterface {

  /**
   * The setting group name used for OpenTelemetry SDK settings.
   */
  public const SETTING_GROUP = 'otsdk';

  /**
   * {@inheritdoc}
   */
  public function hasVariable(string $variableName): bool {
    $sdkSettings = Settings::get(static::SETTING_GROUP, []);
    return isset($sdkSettings[$variableName]);
  }

  /**
   * {@inheritdoc}
   */
  public function retrieveValue(string $variableName): mixed {
    $sdkSettings = Settings::get(static::SETTING_GROUP, []);
    return $sdkSettings[$variableName];
  }

}
