<?php

declare(strict_types=1);

namespace Drupal\otsdk;

use Drupal\otsdk\Configuration\Resolver\SettingsResolver;
use OpenTelemetry\SDK\Common\Configuration\Resolver\CompositeResolver;
use OpenTelemetry\SDK\SdkAutoloader;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\HttpKernelInterface;

/**
 * Register settings resolver and load OpenTelemetry SDK.
 */
final class OtSdkAutoloadMiddleware implements HttpKernelInterface {

  /**
   * Constructs an OtSdkAutoload object.
   */
  public function __construct(
    private readonly HttpKernelInterface $httpKernel,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function handle(Request $request, $type = self::MAIN_REQUEST, $catch = TRUE): Response {
    if ($type === self::MAIN_REQUEST) {
      $this->loadOnce();
    }

    return $this->httpKernel->handle($request, $type, $catch);
  }

  /**
   * Register settings resolver and load OpenTelemetry SDK.
   */
  protected function loadOnce(): void {
    $resolvers = CompositeResolver::instance();
    foreach ($resolvers->getResolvers() as $resolver) {
      if ($resolver instanceof SettingsResolver) {
        return;
      }
    }

    $resolvers->addResolver(new SettingsResolver());
    SdkAutoloader::autoload();
  }

}
