<?php

namespace Drupal\override_cache_control_headers\Drush\Commands;

use Drupal\override_cache_control_headers\Utility;
use Drush\Commands\DrushCommands;

/**
 * Drush commands for override_cache_control_headers module.
 */
class OverrideCacheControlHeadersDrushCommands extends DrushCommands {

  /**
   * The utility service.
   *
   * @var \Drupal\override_cache_control_headers\Utility
   */
  protected $utility;

  /**
   * Constructs a new OverrideCacheControlHeadersDrushCommands object.
   *
   * @param \Drupal\override_cache_control_headers\Utility $utility
   *   The utility service.
   */
  public function __construct(Utility $utility) {
    $this->utility = $utility;
  }

  /**
   * Sets a URL and cache-control header in the state system.
   *
   * @param string $url_headers
   *   The URL and cache-control header in the format `/path|cache-control`.
   *
   * @command override_cache_control_headers:set-temp-headers
   * @aliases occh:set-temp-headers.
   * @usage occh:set-temp-headers "/sitemap.xml|no-cache must-revalidate|10"
   *   Set the specified headers to the URLs,
   *      which is applied for specific number of minutes.
   */
  public function setHeaders(string $url_headers) {
    if (!empty($url_headers)) {
      $url_headers = trim($url_headers);
      $response = $this->utility->validateCacheControlStrings([$url_headers], 'urls_header_temp');
      if (!empty($response)) {
        foreach ($response as $error) {
          $this->output()->writeln("<error>$error</error>");
        }
      }
      else {
        $response = reset($this->utility->validateDuplicateUrls([$url_headers], TRUE));
        if (!empty($response)) {
          $this->output()->writeln("<error>" . $response[0]->__toString() . "</error>");
        }
        else {
          $this->utility->setTempHeadersInState([$url_headers]);
          $this->utility->invalidateCache();
          $this->output()->writeln("<info>Successfully added: $url_headers.</info>");
        }
      }
    }
  }

}
