# Override Cache Control Headers

## Overview

The **Override Cache Control Headers** module lets you override the `Cache-Control` HTTP header on a per-page basis. This is useful for bypassing reverse proxy caches or customizing cache behavior for individual pages.

## Key Features

- **Flexible Cache Control:** Override headers for multiple pages for precise caching control.
- **Optimized Performance:** Tailor cache settings per page to improve site performance.
- **Scheduled Header Overrides:** Temporarily override HTTP headers for a set duration (e.g., set `Cache-Control: public, no-cache` for 60 minutes, then revert).
- **Easy Configuration:** Configure via a simple Drupal admin interface and via Drush.

## Installation

1. Download and install the module using Composer.
2. Enable the module from the **Extend** page (`/admin/modules`) or via Drush.

## Configuration

1. Navigate to the module's configuration page at `/admin/config/develop/override-cache-control-headers`.
2. Enter the URL and the desired `Cache-Control` headers in the provided textarea. Use the `|` symbol to separate the URL from the headers

    ```
    Example: /sitemap.xml|must-revalidate, no-cache, private
    Example with query parameters: /search?category=blog|no-cache, private
    ```
    - URLs can include query parameters for precise matching
    - One entry per line.

3. The module also provides option to override the cache control headers for the specific time period which configured under **Please enter the URL, headers and expiry time in minutes separated by `|` symbol**

    ```
    Example: /sitemap.xml|must-revalidate, no-cache, private|10
    Example with query parameters: /search?category=blog|no-cache, private|15
    ```
    - The last parameter specifies the duration, in minutes, for which the custom headers will be applied to the specified URL. Once the form is saved, the module overrides the cache control headers for that URL. After the configured time period expires, the original headers are automatically restored.
    - URLs can include query parameters for precise matching
    - One entry per line.

4. The cache control override is also set using the drush command as like below

    ```
    drush occh:set-temp-headers "/sitemap.xml|must-revalidate, no-cache, private|10"
    drush occh:set-temp-headers "/search?category=blog|no-cache, private|15"
    ```

## Possible Cache-Control Headers

- `public`: Response may be cached by any cache.
- `private`: Response is for a single user; not for shared caches.
- `no-cache`: Caches must validate with the origin server before using.
- `no-store`: Do not store any part of the request or response.
- `max-age=<seconds>`: Resource is fresh for this many seconds.
- `s-maxage=<seconds>`: Like `max-age`, but for shared caches.
- `must-revalidate`: Stale responses must be validated with the origin server.
- `proxy-revalidate`: Like `must-revalidate`, but for shared caches.
- `immutable`: Response body will not change.
- `stale-while-revalidate=<seconds>`: Serve stale while revalidating in background.
- `stale-if-error=<seconds>`: Serve stale if the origin server errors.

## Example Configuration

```
/sitemap.xml|must-revalidate, no-cache, private
/contact|no-store
/blog|public, max-age=3600
/search?category=*|no-cache, private
/api/data?format=json|no-store
/example/*|must-revalidate, no-cache, private
/example/*/somepage|must-revalidate, no-cache, private
/example/somepage/*|must-revalidate, no-cache, private
```

## Permissions

- **Administer override cache control headers:** Allows users to configure headers for specific URLs.

## Usage

- After configuration, the module applies the specified `Cache-Control` headers to matching URLs.
- The module listens to the `kernel.response` event and modifies response headers accordingly.

## Technical Details

- Configuration form: `OverrideCacheControlHeadersSettingsForm`
- Event subscriber: `OverrideCacheControlHeaders` (listens to `kernel.response`)
- Configuration stored in: `override_cache_control_headers.settings.yml`
- Drush command: `OverrideCacheControlHeadersDrushCommands`
- Provides a hook for custom actions when headers are set (e.g., clearing Varnish/Cloudflare cache):

  ```php
  /**
    * Hook to allow actions after headers are set.
    *
    * @param array $url
    *   Array of affected URLs.
    */
  function hook_override_cache_control_headers(array $url) {
  }
  ```

## Testing

To run unit tests:

```
phpunit --group override_cache_control_headers
```

Tests are located in:

- `OverrideCacheControlHeadersTest`
- `UtilityTest`
