<?php

namespace Drupal\page_cache_single;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Drupal\page_cache_single\StackMiddleware\PageCacheSingle;

/**
 * Service provider to override the default page cache middleware.
 */
class PageCacheSingleServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    if ($container->hasDefinition('http_middleware.page_cache')) {
      $definition = $container->getDefinition('http_middleware.page_cache');
      $definition->setClass(PageCacheSingle::class);
    }
  }

}
