<?php

/**
 * @file
 * Page proxy module hooks documentation.
 */

/**
 * Alter the request options of a page proxy request.
 *
 * The PATH in the function name equals the lowercase base path of the page
 * proxy, with all non-alphanumerical characters being replaced by an
 * underscore.
 *
 * @param array &$options
 *   The array of options, that is used on the request to the external server.
 *   The array is passed to drupal_http_request().
 * @param string &$uri
 *   The URI that the request is directed to.
 *
 * @see drupal_http_request()
 */
function hook_page_proxy_request_PATH_alter(
  array &$options,
  string &$uri,
) {
  $options['headers']['x-custom'] = 'foobar';
}

/**
 * Alter the request options of a proxy page request.
 *
 * @param array &$options
 *   The array of options, that is used on the request to the external server.
 *   The array is passed to drupal_http_request().
 * @param string &$uri
 *   The URI that the request is directed to.
 *
 * @see drupal_http_request()
 */
function hook_page_proxy_request_alter(
  array &$options,
  string &$uri,
) {
  $options['headers']['x-custom'] = 'foobar';
}

/**
 * Alter the response of a page proxy request.
 *
 * The PATH in the function name equals the lowercase base path of the page
 * proxy, with all non-alphanumerical characters being replaced by an
 * underscore.
 *
 * @param array &$response
 *   An array with the following keys:
 *   - status_code: The HTTP status code of the response.
 *   - reason_phrase: The HTTP status reason phrase of the response.
 *   - headers: Array of headers of the response.
 *   - body: The payload of the response.
 * @param string $uri
 *   The URI of the response's request. This is purely informational and
 *   changing it will not have any effect.
 *
 * @see drupal_http_request()
 */
function hook_page_proxy_response_PATH_alter(array &$response, string $uri) {
  if (substr($response['headers']['content-type'][0], 0, 9) === 'text/html') {
    $response['body'] = preg_replace('#(action|src|href)=\\u0022\\/(?!\\/)#',
      '$1=\\u0022\\/page-proxy\\/', $response['body']);
  }
}

/**
 * Alter the response of a page proxy response.
 *
 * @param array &$response
 *   An array with the following keys:
 *   - status_code: The HTTP status code of the response.
 *   - reason_phrase: The HTTP status reason phrase of the response.
 *   - headers: Array of headers of the response.
 *   - body: The payload of the response.
 * @param string $uri
 *   The URI of the response's request. This is purely informational and
 *   changing it will not have any effect.
 *
 * @see drupal_http_request()
 */
function hook_page_proxy_response_alter(array &$response, string $uri) {
  if (substr($response['headers']['content-type'][0], 0, 9) === 'text/html') {
    $response['body'] = preg_replace('#(action|src|href)=\\u0022\\/(?!\\/)#',
      '$1=\\u0022\\/page-proxy\\/', $response['body']);
  }
}
