# Drupal Page Refresh Webhook Module

A lightweight Drupal module that triggers a POST request to a defined URL when
an entity of a specified content type is saved in Drupal.

## Features

- Configurable webhook endpoint
- API key authentication
- Selective content type triggering
- Adjustable crawl depth (1 or 2)

## Requirements

- Drupal 9 or higher
- [Key module](https://www.drupal.org/project/key)

## Installation

Enable the module via the admin interface or by using Drush:

```bash
drush en page_refresh_webhook
```

## Configuration

1. Go to `/admin/config/system/keys` and add your API key.
2. Navigate to `/admin/config/services/page-refresh-webhook` to configure the
   webhook:
    - Enter the URL you want to send the POST request to
    - Select your API key
    - Choose which content types should trigger the webhook
    - Set the depth of the crawl (1 for just the URL, 2 for the URL and attached
      files)
    - Save your configuration

## Usage

Once configured, the module will automatically trigger a POST request when
content of the specified type is saved. The request will include:

- Header: The specified API key
- Payload:
  ```json
  {
    "docs": [
      {
        "url": "URL_OF_THE_ENTITY"
      }
    ],
    "depth": DEPTH
  }
  ```

## Hooks

You can use the hook `hook_page_refresh_webhook_trigger()` to control whether
the webhook should be triggered for a given entity. Refer to
`page_refresh_webhook.api.php` for more information.

## Troubleshooting

Check the Drupal logs at `/admin/reports/dblog` for any error messages or issues
related to the webhook triggering.

## Contributing

Contributions to improve the module are welcome. Please submit issues and pull
requests to the project repository.
