<?php

namespace Drupal\pagedesigner\Service;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\pagedesigner\Entity\Element;

/**
 * The renderer service allows to render a pagedesigner element container.
 */
interface RendererInterface {

  /**
   * Add a style definition.
   *
   * @param string $key
   *   The size for which to add the style definition (mn, sm, xs).
   * @param string $style
   *   The style definition to add.
   * @param int $id
   *   The id of the element.
   */
  public static function addStyle($key, $style, $id);

  /**
   * Preload the elements used on this entity.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The main entity.
   * @param bool $public
   *   Whether we need public elements.
   */
  public function preload(ContentEntityInterface $entity, bool $public = FALSE);

  /**
   * Publicly render a container for a certain entity.
   *
   *   The container to render.
   *   The entity the container is rendered for.
   *
   * @return \Drupal\pagedesigner\Service\Renderer
   *   The renderer service.
   */
  public function renderForPublic(Element $container, ContentEntityBase $entity = NULL);

  /**
   * Render a container for a certain entity.
   *
   * @param \Drupal\pagedesigner\Entity\Element $container
   *   The container to render.
   * @param \Drupal\Core\Entity\ContentEntityBase $entity
   *   The entity the container is rendered for.
   * @param bool $nocache
   *   Disable caching for this render.
   *
   * @return \Drupal\pagedesigner\Service\Renderer
   *   The renderer service.
   */
  public function render(Element $container, ContentEntityBase $entity = NULL, $nocache = FALSE);

  /**
   * Render a container for a certain entity in edit mode.
   *
   * @param \Drupal\pagedesigner\Entity\Element $container
   *   The container to render.
   * @param \Drupal\Core\Entity\ContentEntityBase $entity
   *   The entity the container is rendered for.
   *
   * @return \Drupal\pagedesigner\Service\Renderer
   *   The renderer service.
   */
  public function renderForEdit(Element $container, ContentEntityBase $entity = NULL);

  /**
   * Return the markup generated by the last render.
   *
   * @return string
   *   The generated markup
   */
  public function getMarkup();

  /**
   * Return the styles generated by the last render.
   *
   * @return string
   *   The generated styles.
   */
  public function getStyles();

}
