# Pagedesigner Block Adaptable

A Drupal module that extends the pagedesigner integration
to provide adaptable Views blocks with customizable filters and pager settings.

## Description

The **Pagedesigner Block Adaptable** module allows content editors to customize
the output of Views blocks directly within the Pagedesigner interface.
This module provides a flexible way to create dynamic, filterable Views blocks
that can be configured per pagedesigner element without requiring
developers to create custom blocks for each use case.

## Features

- **Adaptable Views Blocks**: Create Views blocks that can be customized
with different filter values
- **Dynamic Filtering**: Support for various filter types including:
  - String filters
  - Numeric filters
  - Boolean filters
  - Date/time filters
  - Entity filters
  - Bundle filters
  - Taxonomy filters
  - User ID filters
- **Configurable Paging**: Adjust items per page and offset settings
per block instance
- **Pagedesigner Integration**: Seamless integration with
the Pagedesigner module
- **Pattern Support**: Full integration with UI Patterns for consistent theming
- **Error Handling**: Robust error handling with logging and user feedback

## Installation

1. Install the module using Composer:
   ```bash
   composer require drupal/pagedesigner_block_adaptable
   ```

2. Enable the module in the Drupal admin interface or via Drush:
   ```bash
   drush en pagedesigner_block_adaptable
   ```

## Usage

### Creating Adaptable Views Blocks

1. **Create a View**: First, create a View with the desired base configuration
and exposed filters
2. **Configure Filters**: Set up the filters you want to make adaptable
in the View's configuration
3. **Create a display**: Use the "Pagedesigner adaptable block" to create a new display
and add it to your block layout in the pagedesigner region
4. **Customize Settings**: Configure the filter values and pager settings
directly in the Pagedesigner interface

### Supported Filter Types

The module supports various Views filter types:

- **String Filter**: Text-based filtering with operators
like contains, equals, etc.
- **Numeric Filter**: Number-based filtering with comparison operators
- **Boolean Filter**: True/false filtering
- **Bundle Filter**: Content type filtering
- **Entity Filter**: Reference to specific entities
- **Taxonomy Filter**: Taxonomy term filtering
- **DateTime Filter**: Date and time-based filtering
- **UID Filter**: User-based filtering

### Configuration Options

For each adaptable block, you can configure:

- **Filter Values**: Override the default filter values for exposed filters
- **Items Per Page**: Set the number of items to display per page
- **Offset**: Set the starting point for pagination

## Architecture

The module consists of several key components:

### Core Classes

- **AdaptableViewsBlock**: The main block plugin that extends
Drupal's ViewsBlock
- **AdaptableBlock**: Pagedesigner handler for processing
adaptable blocks
- **AdaptableBlockViewBuilder**: Custom view builder for
rendering adaptable blocks
- **FilterPluginManager**: Service for managing filter plugins

### Filter Plugins

The module includes various filter plugins in
`src/Plugin/pagedesigner_block_adaptable/Filter/`:

- `Boolean.php` - Boolean filter handling
- `Bundle.php` - Content type bundle filtering
- `DateTime.php` - Date and time filtering
- `EntityFilter.php` - Entity reference filtering
- `Numeric.php` - Numeric value filtering
- `StringFilter.php` - Text string filtering
- `TaxonomyIndex.php` - Taxonomy term filtering
- `UidFilter.php` - User ID filtering

## Development

### Extending Filter Types

To add support for additional filter types,
create a new plugin in the
`src/Plugin/pagedesigner_block_adaptable/Filter/` directory:

```php
<?php

namespace Drupal\pagedesigner_block_adaptable\Plugin\pagedesigner_block_adaptable\Filter;

use Drupal\pagedesigner_block_adaptable\Plugin\FilterPluginBase;

/**
 * Custom filter plugin.
 *
 * @PagedesignerFilter(
 *   id = "custom_filter",
 *   name = @Translation("Custom Filter")
 * )
 */
class CustomFilter extends FilterPluginBase {
  // Implementation here.
}
```

### API

The module provides a plugin manager service that can be used in custom code:

```php
$filterManager = \Drupal::service('plugin.manager.pagedesigner_block_adaptable_filter');
$filterPlugin = $filterManager->getInstance(['type' => 'string'])[0];
```

## Support

- **Project Page**: [Drupal.org Project Page](https://www.drupal.org/project/pagedesigner_block_adaptable)
- **Issue Queue**: [Drupal.org Issue Queue](https://www.drupal.org/project/issues/pagedesigner_block_adaptable)
- **Source Code**: [git.drupalcode.org](https://git.drupalcode.org/project/pagedesigner_block_adaptable)

## Contributing

Contributions are welcome! Please submit issues and patches through the [Drupal.org issue queue](https://www.drupal.org/project/issues/pagedesigner_block_adaptable). For development, clone the repository from [git.drupalcode.org](https://git.drupalcode.org/project/pagedesigner_block_adaptable).
