# Pagedesigner Megadropdown

A Drupal module that adds megadropdown functionality to
main navigation menus using the Pagedesigner module ecosystem.

## Description

The Pagedesigner Megadropdown module extends the Pagedesigner system
to create rich, content-filled dropdown menus for your site's main navigation.
Instead of simple text-based dropdowns, this module allows you to create
sophisticated megadropdowns that can contain any content you can build
with Pagedesigner including images, formatted text, multiple columns,
and complex layouts.

## Features

- **Rich Content Dropdowns**:
Create megadropdowns with full Pagedesigner content including text,
images, and structured layouts
- **Node-based Content**:
Link navigation items to specific nodes that contain the dropdown content
- **Responsive Design**:
Automatically handles responsive behavior and mobile compatibility
- **Easy Configuration**:
Simple admin interface to connect navigation items with content nodes
- **Hover Interactions**:
Smooth hover effects for showing/hiding dropdown content
- **Multiple Column Support**:
Support for complex multi-column layouts within dropdowns

## Installation

1. **Via Composer**:
   ```bash
   composer require drupal/pagedesigner_megadropdown
   ```

3. **Enable the Module**:
   ```bash
   drush en pagedesigner_megadropdown
   ```
   Or enable through the Drupal admin interface at `/admin/modules`

## Usage

### 1. Create Dropdown Content

1. Create a new node (any content type) that will serve as your dropdown content
2. Use Pagedesigner to build the layout and content for your megadropdown
3. Note the node ID or path for configuration

### 2. Configure Megadropdown Block

1. Go to the block layout administration (`/admin/structure/block`)
2. Add a new "Pagedesigner megadropdown" block to your desired region
3. Configure the block:
   - **Pagedesigner Part**:
   Select to which pagedesigner part entity to assign the megadropdown
   (Usually your main navigation)
   - **Dropdown node**:
    Select or enter the node that contains your dropdown content
   - **Css classe**:
   Add the following class to the block `menu--megadropdown`
   - Configure other Pagedesigner settings as needed
4. Save the block configuration

### 3. Navigation Setup

1. Open the pagedesigner part containing the
main navigation in pagedesigner edit mode.
2. Add a row to the part and add the class `pd-megadropdown` to it.
Usually, the row is directly under the row containing the navigation.

Drag and drop your megadropdown block(s) into the prepared row.

## Support

- **Issue Queue**: [https://www.drupal.org/project/issues/pagedesigner_megadropdown](https://www.drupal.org/project/issues/pagedesigner_megadropdown)
- **Project Page**: [https://www.drupal.org/project/pagedesigner_megadropdown](https://www.drupal.org/project/pagedesigner_megadropdown)

## License

This module is licensed under the GPL-2.0+ license.

## Maintainers

This module is part of the Pagedesigner ecosystem.
See the main Pagedesigner project for maintainer information.
