# Pagedesigner Parts

A Drupal module that extends the Pagedesigner module to enable
reusable page elements like headers, footers, and mega dropdowns
that can be displayed as blocks throughout your site.

## Features

- **Reusable Content Blocks**:
Create pagedesigner content that can be displayed as blocks
- **Content Type Integration**:
Adds a new "Pagedesigner part" content type
- **Block Plugin**:
Provides a configurable block that can render any pagedesigner part
- **Translation Support**:
Full multilingual support for pagedesigner parts
- **Access Control**:
Anonymous users cannot directly access pagedesigner part nodes
- **Menu Integration**:
Dedicated menu system for organizing pagedesigner parts
- **Smart Rendering**:
Different rendering modes for authenticated vs anonymous users

## Installation

1. Install the module using Composer:
   ```bash
   composer require drupal/pagedesigner_parts
   ```

2. Enable the module:
   ```bash
   drush en pagedesigner_parts
   ```

3. Clear caches:
   ```bash
   drush cr
   ```

## Usage

### Creating Pagedesigner Parts

1. Navigate to **Content** → **Add content** → **Pagedesigner part**
2. Enter a title for your part (e.g., "Site Header", "Footer Links")
3. Use the pagedesigner interface to build your content
4. Save the content

### Adding Parts to Your Site

1. Go to **Structure** → **Block layout**
2. Click **Place block** in the desired region
3. Find and configure the **Pagedesigner part** block
4. Select which pagedesigner part to display using the autocomplete field
5. Save the block configuration

### Menu Organization

The module creates a dedicated "Pagedesigner parts" menu
that can be used to organize your reusable components for easier management.

## Configuration

### Block Configuration

When placing a Pagedesigner part block, you can configure:

- **Assigned part**: Select which pagedesigner part content to display
- Standard block settings (visibility, caching, etc.)

## Support

- **Issues**: [Drupal.org Issue Queue](https://www.drupal.org/project/issues/pagedesigner_parts)
- **Source Code**: [Drupal.org Git Repository](http://cgit.drupalcode.org/pagedesigner_parts)
- **Project Page**: [https://www.drupal.org/project/pagedesigner_parts](https://www.drupal.org/project/pagedesigner_parts)

## Contributing

Contributions are welcome! Please follow Drupal coding standards
and submit patches through the official Drupal.org issue queue.
