<?php

namespace Drupal\pagegeofence\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\pagegeofence\Entity\PageGeofenceRule;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Controller for Page Geofence Rule operations.
 */
class PageGeofenceRuleController extends ControllerBase {

  /**
   * Enable a page geofence rule.
   *
   * @param \Drupal\pagegeofence\Entity\PageGeofenceRule $pagegeofence_rule
   *   The page geofence rule entity.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   A redirect response.
   */
  public function enable(PageGeofenceRule $pagegeofence_rule) {
    $pagegeofence_rule->setStatus(TRUE);
    $pagegeofence_rule->save();

    $this->messenger()->addMessage($this->t('The page geofence rule %label has been enabled.', [
      '%label' => $pagegeofence_rule->label(),
    ]));

    return $this->redirect('entity.pagegeofence_rule.collection');
  }

  /**
   * Disable a page geofence rule.
   *
   * @param \Drupal\pagegeofence\Entity\PageGeofenceRule $pagegeofence_rule
   *   The page geofence rule entity.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   A redirect response.
   */
  public function disable(PageGeofenceRule $pagegeofence_rule) {
    $pagegeofence_rule->setStatus(FALSE);
    $pagegeofence_rule->save();

    $this->messenger()->addMessage($this->t('The page geofence rule %label has been disabled.', [
      '%label' => $pagegeofence_rule->label(),
    ]));

    return $this->redirect('entity.pagegeofence_rule.collection');
  }

}