# Page Geofence Redirect Feature

## Overview

The Page Geofence module now supports redirecting restricted users to external URLs instead of showing the default 403 forbidden page.

## How It Works

When creating or editing a geolocation rule, you can now specify an optional **Redirect URL** field:

- **With Redirect URL**: Users from restricted countries will be redirected (302 redirect) to the specified URL
- **Without Redirect URL**: Users from restricted countries will see the default 403 forbidden page with the restriction reason

## Configuration

1. Navigate to **Administration > Configuration > System > Page Geofence Rules**
2. Create a new rule or edit an existing one
3. In the **Redirect URL** field, enter:
   - **Internal URL**: `/path/to/page` (e.g., `/access-denied`)
   - **External URL**: `https://example.com/blocked`
4. Leave the field empty to use the default 403 page behavior

## Validation & Security

The module includes several validation checks:

- **URL Format**: Internal URLs must start with `/`, external URLs must be valid HTTP/HTTPS
- **Loop Prevention**: Cannot redirect to URLs that match the restricted page patterns
- **HTTPS Recommendation**: Shows a warning if HTTP is used for external redirects

## Examples

### Example 1: Internal Redirect to Access Denied Page
- **Redirect URL**: `/access-denied`
- **Result**: Restricted users are redirected to your internal access denied page

### Example 2: External Redirect to Company Policy Page
- **Redirect URL**: `https://company.com/geographic-restrictions`
- **Result**: Restricted users are redirected to your external policy explanation page

### Example 3: External Redirect to Localized Version
- **Redirect URL**: `https://company.eu/restricted-content`
- **Result**: Restricted users are redirected to a region-appropriate version

### Example 4: Default 403 Page
- **Redirect URL**: (empty)
- **Result**: Shows built-in 403 page with restriction reason

## Logging

All redirect actions are logged with the same detail level as 403 responses:
- User's country
- Restricted path
- Applied rule name
- Whether redirect or 403 was used

## Admin Interface

The rules list now shows the action type:
- **"Redirect to example.com"** for rules with redirect URLs
- **"Show 403 page"** for rules using the default behavior

## Technical Implementation

- **Redirect Type**: Uses HTTP 302 (temporary redirect) status code
- **Internal URLs**: Automatically converted to absolute URLs using current domain
- **External URLs**: Used as-is for the redirect
- **Loop Prevention**: Validates that redirect URLs don't match restricted page patterns
- **Schema Support**: Added `redirect_url` to configuration schema
- **Backward Compatibility**: Preserves all existing validation and conflict checking
- **Performance**: No impact on non-restricted requests