(function ($, Drupal, once) {

  'use strict';

  Drupal.behaviors.paletteEntityBrowserView = {
    attach: function (context) {
      const $viewContent = $('.view-id-palette .view-content', context);
      const $viewRows = $('.views-row', context);

      function updateRowStyle($row, $input) {
        const isChecked = $input.prop('checked');
        const label = $row.find('.views-field-label').text().trim();
        const colorHex = $row.find('.views-field-rgb').text().trim();

        if (label && colorHex) {
          $row.attr('title', `${label} (${colorHex})`);
        }

        $row.css({
          'background-color': colorHex || '#eee',
          'border': `3px solid ${isChecked ? '#007bff' : 'transparent'}`,
          'border-radius': '50%',
          width: '50px',
          height: '50px',
          display: 'inline-block',
          margin: '10px',
          cursor: 'pointer',
          transition: 'transform 0.2s ease, border-color 0.2s ease',
          'box-shadow': isChecked ? '0 0 8px rgba(0,123,255,0.6)' : '0 2px 4px rgba(0,0,0,0.1)',
          position: 'relative',
          overflow: 'hidden',
          transform: isChecked ? 'scale(1.1)' : 'scale(1)'
        });

        $row.find('> div').css('display', 'none');
      }
      
      if ($viewContent.length) {
        $viewContent.css({
          display: 'flex',
          'flex-wrap': 'wrap',
          'justify-content': 'flex-start'
        });
      }

      $viewRows.each(function () {
        const $row = $(this);
        const $input = $row.find('input[name^="entity_browser_select"]');
        if ($input.length) {
          updateRowStyle($row, $input);
        }
      });

      $(once('palette-single-select', '.views-row', context)).on('click', function (e) {
        if ($(e.target).is('input')) return;

        const $row = $(this);
        const $input = $row.find('input[name^="entity_browser_select"]');

        if ($input.length) {
          const shouldCheck = !$input.prop('checked');

          $viewRows.each(function () {
            const $otherRow = $(this);
            const $otherInput = $otherRow.find('input[name^="entity_browser_select"]');
            if ($otherInput.length && $otherInput[0] !== $input[0]) {
              $otherInput.prop('checked', false);
              updateRowStyle($otherRow, $otherInput);
            }
          });

          $input.prop('checked', shouldCheck);
          updateRowStyle($row, $input);
          $input.trigger('change');
        }
      });

      $viewRows.hover(
        function () {
          if (!$(this).find('input[name^="entity_browser_select"]').prop('checked')) {
            $(this).css('transform', 'scale(1.1)');
          }
        },
        function () {
          if (!$(this).find('input[name^="entity_browser_select"]').prop('checked')) {
            $(this).css('transform', 'scale(1)');
          }
        }
      );

      $(once('palette-update-parent', 'input[name^="entity_browser_select"]', context))
        .on('change', function () {
          const $input = $(this);
          if (!$input.prop('checked')) return;

          const $row = $input.closest('.views-row');
          const colorHex = $row.find('.views-field-rgb').text().trim();
          const colorLabel = $row.find('.views-field-label').text().trim();

          if (!colorHex) return;

          const urlParams = new URLSearchParams(window.location.search);
          const uuid = urlParams.get('uuid');

          if (!uuid) return;

          const $parentDoc = $(window.parent.document);
          const $trigger = $parentDoc.find(`[data-uuid="${uuid}"]`);

          if ($trigger.length === 0) return;

          const $widget = $trigger.closest('.palette-color-widget-container');

          $widget.find('.palette-color-input-wrapper')
            .css({
              position: 'absolute',
              left: '-9999px',
              width: '1px',
              height: '1px',
              overflow: 'hidden'
            });

          $widget.find('.palette-selected-info').show();

          $widget.find('.palette-color-preview').css('background-color', colorHex);

          $widget.find('.palette-color-label').text(colorLabel || colorHex);

          $widget.find('input.palette-color-input').val(colorHex);
        });
    }
  };

})(jQuery, Drupal, once);
