<?php

namespace Drupal\Tests\pantheon_content_publisher\Kernel;

/**
 * Test description.
 *
 * @group pantheon_document
 */
interface PantheonContentDocumentTestInterface {

  const ARTICLE_ID = '1_dRWJT4gJ05ZwtD6HyE1GdRxExL4FIAMkDIcIH8nlgM';

  /**
   * The key is a method name, the value is a GraphQL query string template.
   *
   * Most methods store the query generated by the same named method on the
   * GraphQL class except for getPage2ArticleIds which stores the call to
   * getArticleIds asking for the second page.
   *
   *  %s in the template stands for site id or article id, depending on the
   *  query type stored in ::QUERY_TYPES.
   */
  const QUERIES = [
    'metadata' => '{site(id:"%s"){metadataFields}}',
    'getArticle' => '{article(id:"%s"){title,content,slug,metadata}}',
    'getArticles' => '{articlesv3{articles{id,title,metadata}}}',
    'getArticleIds' => '{articlesv3(pageSize:100){articles{id},pageInfo{nextCursor}}}',
    'getArticleIdsButJustOne' => '{articlesv3(pageSize:1){articles{id},pageInfo{nextCursor}}}',
    'getPage2ArticleIds' => '{articlesv3(pageSize:100,cursor:"next cursor"){articles{id},pageInfo{nextCursor}}}',
  ];

  /**
   * The query type, defaults to articlesv3.
   */
  const QUERY_TYPES = [
    'metadata' => 'site',
    'getArticle' => 'article',
  ];

}
