# Pantheon SI Tokens

Exposes Pantheon Secure Integration (SI) PHP constants as Drupal tokens for
easy integration with site configuration, content, and third-party modules.

## Overview

When using Pantheon's Secure Integration feature, PHP constants are made
available to your application in the format `PANTHEON_SOIP_SERVICENAME`. These
constants contain port numbers for secure tunnels to behind-firewall services.

This module allows you to configure which constants to expose and makes them
available as Drupal tokens in the format
`[pantheon_si_tunnel:pantheon_soip_servicename]`, enabling their use anywhere
tokens are supported.

## Features

* **Configurable constants**: Select which Pantheon SI PHP constants to expose
  as tokens
* **Token integration**: Full integration with Drupal's token system
* **Dynamic token discovery**: Tokens are automatically generated based on your
  configuration
* **Clean token syntax**: Simple, predictable token format based on constant
  names

## Requirements

* Drupal 10.1+ or Drupal 11
* Token module (drupal/token)
* Pantheon hosting with Secure Integration configured

## Installation

1. Install via Composer:
   ```bash
   composer require drupal/pantheon_si_tokens
   ```

2. Enable the module:
   ```bash
   drush en pantheon_si_tokens
   ```

## Usage

### Configuration

1. Navigate to **Configuration > System > Pantheon SI Tokens**
   (`/admin/config/system/pantheon-si-tokens`)

2. Enter your Pantheon SI PHP constants, one per line:
   ```
   PANTHEON_SOIP_LDAP
   PANTHEON_SOIP_DATABASE
   PANTHEON_SOIP_API
   ```

3. Save the configuration

### Using Tokens

Once configured, tokens become available throughout your Drupal site. The token
format is based on the constant name converted to lowercase:

* `PANTHEON_SOIP_LDAP` → `[pantheon_si_tunnel:pantheon_soip_ldap]`
* `PANTHEON_SOIP_DATABASE` → `[pantheon_si_tunnel:pantheon_soip_database]`
* `PANTHEON_SOIP_API` → `[pantheon_si_tunnel:pantheon_soip_api]`

### Example Use Cases

**LDAP Configuration:**
Configure LDAP module to use:
```
Server: 127.0.0.1
Port: [pantheon_si_tunnel:pantheon_soip_ldap]
```

**Custom Configuration:**
Use in configuration forms that support tokens to dynamically reference your
secure tunnel ports.

**Content:**
Reference tunnel information in content where token replacement is enabled.

## How It Works

1. You configure which PHP constants to expose via the admin interface
2. The module implements `hook_token_info()` to register tokens for each
   configured constant
3. When tokens are replaced, `hook_tokens()` reads the PHP constant value and
   provides it as the token replacement

## Beta Status Note

This module is currently in beta. The API is stable and the module is ready for
production use, but community feedback is welcome to refine features and
documentation before the 1.0.0 stable release.

## Troubleshooting

**Tokens not appearing:**
- Verify the module is enabled
- Check that you've configured constants in the settings form
- Clear Drupal cache (`drush cr`)

**Empty token values:**
- Ensure the PHP constant is actually defined by Pantheon SI
- Verify constant names are spelled correctly (case-sensitive)
- Check that Secure Integration is properly configured on Pantheon

**Configuration not saving:**
- Verify you have "Administer site configuration" permission
- Check for PHP errors in Drupal logs

## Security Considerations

This module only exposes PHP constants that you explicitly configure. It does
not automatically expose all constants or provide access to sensitive
information beyond what Pantheon SI already makes available to your
application.

## Documentation

For more information about Pantheon Secure Integration:
https://docs.pantheon.io/guides/secure-development/secure-integration

## License

This project is licensed under the GPL v2 or later.
