<?php

declare(strict_types=1);

namespace Drupal\panther\Drupal\Manager;

/**
 * Default implementation of the Drupal user manager service.
 */
class DrupalUserManager implements DrupalUserManagerInterface {

  /**
   * The user object representing the currently logged-in user.
   *
   * @var \stdClass|bool
   */
  protected \stdClass|bool $user = FALSE;

  /**
   * An array of user objects representing users created during the test.
   *
   * @var \stdClass[]
   */
  protected array $users = [];

  public function getCurrentUser(): \stdClass|bool {
    return $this->user;
  }

  public function setCurrentUser(\stdClass|bool $user): void {
    $this->user = $user;
  }

  public function addUser(\stdClass $user): void {
    $this->users[$user->name] = $user;
  }

  public function removeUser(string $userName): void {
    unset($this->users[$userName]);
  }

  public function getUser(string $userName): \stdClass {
    if (!isset($this->users[$userName])) {
      throw new \InvalidArgumentException(\sprintf('No user with %s name is registered with the driver.', $userName));
    }
    return $this->users[$userName];
  }

  /**
   * {@inheritdoc}
   */
  public function getUsers(): array {
    return $this->users;
  }

  public function clearUsers(): void {
    $this->user = FALSE;
    $this->users = [];
  }

  public function hasUsers(): bool {
    return \count($this->users) > 0;
  }

  public function currentUserIsAnonymous(): bool {
    return $this->user === FALSE;
  }

}
