<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit\Output;

class NameUtil {

  public static function friendly(string $method): string {
    $suffix = '';

    if (\preg_match('#with data set "(?<dataset>.*)"$#', $method, $matches) === 1) {
      $suffix = " [{$matches['dataset']}]";

      $pos = \strpos($method, 'with data set');
      if ($pos === FALSE) {
        return $method;
      }

      $method = \substr($method, 0, $pos);
    }

    return static::wordsWithSpaces(
        \str_replace('_', ' ', $method),
      ) . $suffix;
  }

  /**
   * Convert a string to snake case.
   */
  protected static function wordsWithSpaces(string $value, string $delimiter = ' '): string {
    $value = \preg_replace('/\s+/u', '', \ucwords($value));
    if ($value === NULL) {
      return '';
    }

    $value = \preg_replace('/(.)(?=[A-Z])/u', '$1' . $delimiter, $value);
    if ($value === NULL) {
      return '';
    }

    return \mb_strtolower(
      $value,
      'UTF-8',
    );
  }

}
