<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit\Output;

use PHPUnit\Event\Telemetry\Duration;
use PHPUnit\Event\Telemetry\MemoryUsage;

final class ResourceUsageFormatter {

  private const SIZES = [
    'GB' => 1073741824,
    'MB' => 1048576,
    'KB' => 1024,
  ];

  public function resourceUsage(Duration $duration, MemoryUsage $memory_usage): string {
    return \sprintf(
          'Time: %s, Memory: %s',
          $duration->asString(),
          $this->bytesToString($memory_usage->bytes()),
      );
  }

  private function bytesToString(int $bytes): string {
    foreach (self::SIZES as $unit => $value) {
      if ($bytes >= $value) {
        return \sprintf('%.2f %s', $bytes / $value, $unit);
      }
    }

    return $bytes . ' byte' . ($bytes !== 1 ? 's' : '');
  }

}
