<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit;

use Drupal\panther\Phpunit\Context\TestContext;
use Drupal\panther\Phpunit\Output\DelayedPrinter;
use Drupal\panther\Phpunit\Output\Formatter;
use Drupal\panther\Phpunit\Output\FormatterInterface;
use Drupal\panther\Phpunit\Output\InstantPrinter;
use Drupal\panther\Phpunit\Output\PrinterInterface;
use Drupal\panther\Phpunit\Subscribers\TestBeforeMethodErroredSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestConsideredRiskySubscriber;
use Drupal\panther\Phpunit\Subscribers\TestErroredSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestFailedSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestFinishedSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestMarkedIncompleteSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestPassedSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestPhpDeprecationTriggeredSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestPreparationStartedSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestPrintedUnexpectedOutputSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestRunnerExecutionStartedSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestRunnerFinishedSubscriber;
use Drupal\panther\Phpunit\Subscribers\TestWarningTriggeredSubscriber;
use PHPUnit\Runner\Extension\Extension;
use PHPUnit\Runner\Extension\Facade;
use PHPUnit\Runner\Extension\ParameterCollection;
use PHPUnit\TextUI\Configuration\Configuration;
use PHPUnit\TextUI\Output\DefaultPrinter;

class PrintPantherResultsExtension implements Extension {

  public function bootstrap(
    Configuration $configuration,
    Facade $facade,
    ParameterCollection $parameters,
  ): void {
    if ($configuration->noOutput()) {
      return;
    }

    $context = new TestContext(
      $this->getBaseTestsPath(),
      $this->makeFormatter(),
      $this->makePrinter($configuration),
    );

    $facade->registerSubscribers(
      new TestConsideredRiskySubscriber($context),
      new TestErroredSubscriber($context),
      new TestFailedSubscriber($context),
      new TestFinishedSubscriber($context),
      new TestMarkedIncompleteSubscriber($context),
      new TestPassedSubscriber($context),
      new TestPhpDeprecationTriggeredSubscriber($context),
      new TestPreparationStartedSubscriber($context),
      new TestPrintedUnexpectedOutputSubscriber($context),
      new TestRunnerExecutionStartedSubscriber($context),
      new TestRunnerFinishedSubscriber($context),
      new TestWarningTriggeredSubscriber($context),
      new TestBeforeMethodErroredSubscriber($context),
    );

    $facade->replaceResultOutput();
  }

  protected function getBaseTestsPath(): string {
    $slash = DIRECTORY_SEPARATOR;

    return \realpath(__DIR__ . "{$slash}..{$slash}..{$slash}..{$slash}") . $slash;
  }

  protected function makeFormatter(): FormatterInterface {
    return new Formatter();
  }

  protected function makePrinter(Configuration $config): PrinterInterface {
    if ($config->noProgress()) {
      return new InstantPrinter(
        DefaultPrinter::standardOutput(),
      );
    }

    return new DelayedPrinter(
      DefaultPrinter::standardOutput(),
    );
  }

}
