<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit\Subscribers;

trait MessageTrait {

  private function renderMessage(string $message, string $stack_trace): string {
    return \sprintf(
      '%s Stack trace: %s',
      $this->getFirstLine($message),
      $this->renderStackTrace($stack_trace),
    );
  }

  private function getFirstLine(string $message): string {
    $lines = \explode("\n", $message);

    return \array_shift($lines);
  }

  private function renderStackTrace(string $stack_trace): string {
    $lines = \explode("\n", $stack_trace);
    $lines = \array_filter($lines, static function ($line) {
      return $line !== '';
    });
    $lines = \array_map(static function ($line) {
      return \preg_replace('/\/var\/www\/html\//', '', $line);
    }, $lines);

    return \implode(" -> ", $lines);
  }

}
