<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit\Subscribers;

use Drupal\panther\Phpunit\Context\TestContext;
use PHPUnit\Event\Test\MarkedIncomplete;
use PHPUnit\Event\Test\MarkedIncompleteSubscriber;

class TestMarkedIncompleteSubscriber implements MarkedIncompleteSubscriber {

  use MessageTrait;

  public function __construct(protected readonly TestContext $context) {
  }

  public function notify(MarkedIncomplete $event): void {
    $message = $event->throwable()->message();
    $stack_trace = $event->throwable()->stackTrace();

    $this
      ->context
      ->markTestFailed($this->renderMessage($message, $stack_trace));
  }

}
