<?php

declare(strict_types=1);

namespace Drupal\Tests\panther\FunctionalJavascript\Constraint;

use PHPUnit\Framework\Constraint\Constraint;
use Symfony\Component\Panther\DomCrawler\Crawler;

final class CrawlerSelectorDisabled extends Constraint {

  public function __construct(private readonly string $selector) {}

  public function toString(): string {
    return \sprintf('selector "%s" is enabled', $this->selector);
  }

  protected function matches(mixed $other): bool {
    if (!$other instanceof Crawler) {
      return FALSE;
    }

    $xpath = \sprintf(
      ".//label[text()[contains(.,'%s')]][1]/following-sibling::input[1]",
      $this->selector,
    );
    $input = $other->filterXPath($xpath);

    return $input->getAttribute('disabled') !== NULL;
  }

}
