<?php

declare(strict_types=1);

namespace Drupal\Tests\panther\FunctionalJavascript\Constraint;

use PHPUnit\Framework\Constraint\Constraint;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

final class ResponseHeaderLocationSame extends Constraint {

  public function __construct(
    private Request $request,
    private string $expectedValue,
  ) {
  }

  public function toString(): string {
    return \sprintf('has header "Location" matching "%s"', $this->expectedValue);
  }

  protected function matches(mixed $other): bool {
    if (!$other instanceof Response) {
      return FALSE;
    }

    $location = $other->headers->get('Location');

    if (NULL === $location) {
      return FALSE;
    }

    return $this->toFullUrl($this->expectedValue) === $this->toFullUrl($location);
  }

  protected function failureDescription(mixed $other): string {
    return 'the Response ' . $this->toString();
  }

  private function toFullUrl(string $url): string {
    if (NULL === \parse_url($url, \PHP_URL_PATH)) {
      $url .= '/';
    }

    if (\str_starts_with($url, '//')) {
      return \sprintf('%s:%s', $this->request->getScheme(), $url);
    }

    if (\str_starts_with($url, '/')) {
      return $this->request->getSchemeAndHttpHost() . $url;
    }

    return $url;
  }

}
