<?php

declare(strict_types=1);

namespace Drupal\panther\Axe;

use Twig\Environment;
use Twig\Loader\FilesystemLoader;

class AccessibilityReportDumper {

  /**
   * @phpstan-param array<array-key, mixed> $baseContext
   */
  public function __construct(
    private readonly array $baseContext = [],
  ) {
  }

  /**
   * @phpstan-param array<array-key, mixed> $report
   */
  public function dump(array $report, string $file_path): void {
    if (\count($report) === 0) {
      return;
    }

    $loader = new FilesystemLoader($this->getModulePath() . '/templates');
    $twig = new Environment($loader);

    $context = [
      'report' => $report,
    ] + $this->baseContext;

    $report_content = $twig->render('accessibility_report.html.twig', $context);

    \file_put_contents($file_path, $report_content);
  }

  private function getModulePath(): string {
    /** @var \Drupal\Core\Extension\ModuleExtensionList $module_extension_list */
    // @phpstan-ignore-next-line
    $module_extension_list = \Drupal::service('extension.list.module');

    return $module_extension_list->getPath('panther');
  }

}
